package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.ModalidadOrganizacionPreventivaDao;
import com.ejie.ab04b.model.ModalidadOrganizacionPreventiva;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab04b74s00ServiceImpl generated by UDA, 11-Jan-2017 12:23:08.
 * 
 * @author UDA
 */

@Service(value = "ModalidadOrganizacionPreventivaService")
public class ModalidadOrganizacionPreventivaServiceImpl implements
		ModalidadOrganizacionPreventivaService {

	@Autowired()
	private ModalidadOrganizacionPreventivaDao ab04b74s00Dao;

	/**
	 * Inserts a single row in the Ab04b74s00 table.
	 * 
	 *  ab04b74s00
	 *            Ab04b74s00
	 *  Ab04b74s00
	 *
	 * @param ab04b74s00 the ab 04 b 74 s 00
	 * @return the modalidad organizacion preventiva
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ModalidadOrganizacionPreventiva add(
			ModalidadOrganizacionPreventiva ab04b74s00) {
		return this.ab04b74s00Dao.add(ab04b74s00);
	}

	/**
	 * Updates a single row in the Ab04b74s00 table.
	 * 
	 *  ab04b74s00
	 *            Ab04b74s00
	 *  Ab04b74s00
	 *
	 * @param ab04b74s00 the ab 04 b 74 s 00
	 * @return the modalidad organizacion preventiva
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ModalidadOrganizacionPreventiva update(
			ModalidadOrganizacionPreventiva ab04b74s00) {
		return this.ab04b74s00Dao.update(ab04b74s00);
	}

	/**
	 * Finds a single row in the Ab04b74s00 table.
	 * 
	 *  ab04b74s00
	 *            Ab04b74s00
	 *  Ab04b74s00
	 *
	 * @param ab04b74s00 the ab 04 b 74 s 00
	 * @return the modalidad organizacion preventiva
	 */
	public ModalidadOrganizacionPreventiva find(
			ModalidadOrganizacionPreventiva ab04b74s00) {
		return (ModalidadOrganizacionPreventiva) this.ab04b74s00Dao
				.find(ab04b74s00);
	}

	/**
	 * Deletes a single row in the Ab04b74s00 table.
	 * 
	 *  ab04b74s00
	 *            Ab04b74s00
	 *
	 * @param ab04b74s00 the ab 04 b 74 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(ModalidadOrganizacionPreventiva ab04b74s00) {
		this.ab04b74s00Dao.remove(ab04b74s00);
	}

	/**
	 * Finds a list of rows in the Ab04b74s00 table.
	 * 
	 *  ab04b74s00
	 *            Ab04b74s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab04b74s00>
	 *
	 * @param ab04b74s00 the ab 04 b 74 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<ModalidadOrganizacionPreventiva> findAll(
			ModalidadOrganizacionPreventiva ab04b74s00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<ModalidadOrganizacionPreventiva>) this.ab04b74s00Dao
				.findAll(ab04b74s00, jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab04b74s00 table using like.
	 * 
	 *  ab04b74s00
	 *            Ab04b74s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab04b74s00>
	 *
	 * @param ab04b74s00 the ab 04 b 74 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<ModalidadOrganizacionPreventiva> findAllLike(
			ModalidadOrganizacionPreventiva ab04b74s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<ModalidadOrganizacionPreventiva>) this.ab04b74s00Dao
				.findAllLike(ab04b74s00, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Ab04b74s00 table.
	 * 
	 *  filterAb04b74s00
	 *            Ab04b74s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *
	 * @param filterAb04b74s00 the filter ab 04 b 74 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	public void removeMultiple(
			ModalidadOrganizacionPreventiva filterAb04b74s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.ab04b74s00Dao.removeMultiple(filterAb04b74s00, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the Ab04b74s00 table.
	 * 
	 *  filterAb04b74s00
	 *            Ab04b74s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab04b74s00>
	 *
	 * @param filterAb04b74s00 the filter ab 04 b 74 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<ModalidadOrganizacionPreventiva> filter(
			ModalidadOrganizacionPreventiva filterAb04b74s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<ModalidadOrganizacionPreventiva> listaAb04b74s00 = this.ab04b74s00Dao
				.findAllLike(filterAb04b74s00, jqGridRequestDto, false);
		Long recordNum = this.ab04b74s00Dao.findAllLikeCount(
				filterAb04b74s00 != null ? filterAb04b74s00
						: new ModalidadOrganizacionPreventiva(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<ModalidadOrganizacionPreventiva>> reorderSelection = this.ab04b74s00Dao
					.reorderSelection(filterAb04b74s00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<ModalidadOrganizacionPreventiva>(
					jqGridRequestDto, recordNum, listaAb04b74s00,
					reorderSelection);
		}
		return new JQGridResponseDto<ModalidadOrganizacionPreventiva>(
				jqGridRequestDto, recordNum, listaAb04b74s00);
	}

	/**
	 * Searches rows in the Ab04b74s00 table.
	 * 
	 *  filterAb04b74s00
	 *            Ab04b74s00
	 *  searchAb04b74s00
	 *            Ab04b74s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab04b74s00>>
	 *
	 * @param filterAb04b74s00 the filter ab 04 b 74 s 00
	 * @param searchAb04b74s00 the search ab 04 b 74 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<ModalidadOrganizacionPreventiva>> search(
			ModalidadOrganizacionPreventiva filterAb04b74s00,
			ModalidadOrganizacionPreventiva searchAb04b74s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab04b74s00Dao.search(filterAb04b74s00, searchAb04b74s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab04b74s00 table.
	 * 
	 *  filterAb04b74s00
	 *            Ab04b74s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb04b74s00 the filter ab 04 b 74 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(
			ModalidadOrganizacionPreventiva filterAb04b74s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab04b74s00Dao.reorderSelection(filterAb04b74s00,
				jqGridRequestDto, startsWith);
	}

}
